/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.jdbc.OracleConnection;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

public class TIMESTAMPTZ
extends Datum {
    private static int CENTURY_DEFAULT = 119;
    private static int DECADE_DEFAULT = 100;
    private static int MONTH_DEFAULT = 1;
    private static int DAY_DEFAULT = 1;
    private static int DECADE_INIT = 170;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static int SIZE_TIMESTAMPTZ = 13;
    private static int SIZE_TIMESTAMP = 11;
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;

    public TIMESTAMPTZ() {
        super(TIMESTAMPTZ.initTimestamptz());
    }

    public TIMESTAMPTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string));
    }

    public TIMESTAMPTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, string, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date));
    }

    public TIMESTAMPTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time));
    }

    public TIMESTAMPTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp));
    }

    public TIMESTAMPTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPTZ.toBytes(connection, dATE));
    }

    public TIMESTAMPTZ(byte[] byArray) {
        super(byArray);
    }

    private static int getHighOrderbits(int n) {
        return (n & 0x7F) << 6;
    }

    private static int getJavaYear(int n, int n2) {
        return (n - 100) * 100 + (n2 - 100);
    }

    private static int getLowOrderbits(int n) {
        return (n & 0xFC) >> 2;
    }

    private static byte[] initTimestamptz() {
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        Calendar calendar = Calendar.getInstance();
        byArray[0] = (byte)CENTURY_DEFAULT;
        byArray[1] = (byte)DECADE_INIT;
        byArray[2] = (byte)MONTH_DEFAULT;
        byArray[3] = (byte)DAY_DEFAULT;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        String string = new String(calendar.getTimeZone().getID());
        byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
        byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
        byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        return byArray;
    }

    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public Object makeJdbcArray(int n) {
        Timestamp[] timestampArray = new Timestamp[n];
        return timestampArray;
    }

    private static int setHighOrderbits(int n) {
        return (n & 0x1FC0) >> 6;
    }

    private static int setLowOrderbits(int n) {
        return (n & 0x3F) << 2;
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        return TIMESTAMPTZ.toTimestamp(connection, this.getBytes());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, String string) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(string));
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        return TIMESTAMPTZ.toBytes(connection, Timestamp.valueOf(string), calendar);
    }

    public static byte[] toBytes(Connection connection, Date date) throws SQLException {
        int n;
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        String string = ((OracleConnection)connection).getSessionTimeZone();
        Calendar calendar = string == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(string));
        calendar.setTime(date);
        boolean bl = calendar.getTimeZone().inDaylightTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string2 = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string2);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
            n = offsetDST.getOFFSET();
            if (bl && by == 1) {
                if (offsetDST.getDSTFLAG() == 0) {
                    n += HOUR_MILLISECOND;
                } else {
                    throw new SQLException();
                }
            }
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string2));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string2));
        }
        calendar.add(10, -(n / HOUR_MILLISECOND));
        calendar.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        int n;
        if (date == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        boolean bl = calendar.getTimeZone().inDaylightTime(date);
        calendar2.set(11, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar2, n2, offsetDST);
            n = offsetDST.getOFFSET();
            if (bl && by == 1) {
                if (offsetDST.getDSTFLAG() == 0) {
                    n += HOUR_MILLISECOND;
                } else {
                    throw new SQLException();
                }
            }
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        }
        calendar2.add(10, -(n / HOUR_MILLISECOND));
        calendar2.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar2.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar2.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Time time) throws SQLException {
        int n;
        if (time == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        String string = ((OracleConnection)connection).getSessionTimeZone();
        Calendar calendar = string == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(string));
        calendar.setTime(time);
        if (calendar.getTimeZone().inDaylightTime(time)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        calendar.set(1, (CENTURY_DEFAULT - 100) * 100 + DECADE_DEFAULT % 100);
        calendar.set(2, MONTH_DEFAULT - 1);
        calendar.set(5, DAY_DEFAULT);
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string2 = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string2);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
            n = offsetDST.getOFFSET();
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string2));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string2));
        }
        calendar.add(10, -(n / HOUR_MILLISECOND));
        calendar.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        int n;
        if (time == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        calendar2.setTime(time);
        boolean bl = calendar.getTimeZone().inDaylightTime(time);
        calendar2.set(1, (CENTURY_DEFAULT - 100) * 100 + DECADE_DEFAULT % 100);
        calendar2.set(2, MONTH_DEFAULT - 1);
        calendar2.set(5, DAY_DEFAULT);
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar2, n2, offsetDST);
            n = offsetDST.getOFFSET();
            if (bl && by == 1) {
                if (offsetDST.getDSTFLAG() == 0) {
                    n += HOUR_MILLISECOND;
                } else {
                    throw new SQLException();
                }
            }
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        }
        calendar2.add(11, -(n / HOUR_MILLISECOND));
        calendar2.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar2.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar2.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp) throws SQLException {
        int n;
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        String string = ((OracleConnection)connection).getSessionTimeZone();
        Calendar calendar = string == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(string));
        calendar.setTime(timestamp);
        boolean bl = calendar.getTimeZone().inDaylightTime(timestamp);
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string2 = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string2);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
            n = offsetDST.getOFFSET();
            if (bl && by == 1) {
                if (offsetDST.getDSTFLAG() == 0) {
                    n += HOUR_MILLISECOND;
                } else {
                    throw new SQLException();
                }
            }
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string2));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string2));
        }
        calendar.add(10, -(n / HOUR_MILLISECOND));
        calendar.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = (byte)(timestamp.getNanos() >> 24);
        byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
        byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
        byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        int n;
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        boolean bl = calendar.getTimeZone().inDaylightTime(timestamp);
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
            n = offsetDST.getOFFSET();
            if (bl && by == 1) {
                if (offsetDST.getDSTFLAG() == 0) {
                    n += HOUR_MILLISECOND;
                } else {
                    throw new SQLException();
                }
            }
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        }
        calendar2.add(10, -(n / HOUR_MILLISECOND));
        calendar2.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar2.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar2.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        byArray[7] = (byte)(timestamp.getNanos() >> 24);
        byArray[8] = (byte)(timestamp.getNanos() >> 16 & 0xFF);
        byArray[9] = (byte)(timestamp.getNanos() >> 8 & 0xFF);
        byArray[10] = (byte)(timestamp.getNanos() & 0xFF);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE) throws SQLException {
        int n;
        if (dATE == null) {
            return null;
        }
        byte[] byArray = new byte[SIZE_TIMESTAMPTZ];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DATE.toDate(dATE.toBytes()));
        boolean bl = calendar.getTimeZone().inDaylightTime(DATE.toDate(dATE.toBytes()));
        if (calendar.getTimeZone().getID() == "Custom") {
            n = calendar.getTimeZone().getRawOffset();
            byArray[11] = (byte)(n / HOUR_MILLISECOND + OFFSET_HOUR);
            byArray[12] = (byte)(n % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE);
        } else {
            String string = new String(calendar.getTimeZone().getID());
            int n2 = ZONEIDMAP.getID(string);
            if (n2 == ZONEIDMAP.INV_ZONEID) {
                throw new SQLException("Timezone not supported");
            }
            if (TIMEZONETAB.checkID(n2)) {
                TIMEZONETAB.updateTable(connection, n2);
            }
            OffsetDST offsetDST = new OffsetDST();
            byte by = TIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
            n = offsetDST.getOFFSET();
            if (bl && by == 1) {
                if (offsetDST.getDSTFLAG() == 0) {
                    n += HOUR_MILLISECOND;
                } else {
                    throw new SQLException();
                }
            }
            byArray[11] = (byte)TIMESTAMPTZ.setHighOrderbits(ZONEIDMAP.getID(string));
            byArray[11] = (byte)(byArray[11] | REGIONIDBIT);
            byArray[12] = (byte)TIMESTAMPTZ.setLowOrderbits(ZONEIDMAP.getID(string));
        }
        calendar.add(10, -(n / HOUR_MILLISECOND));
        calendar.add(12, -(n % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
        byArray[0] = (byte)(calendar.get(1) / 100 + 100);
        byArray[1] = (byte)(calendar.get(1) % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[7] = 0;
        byArray[8] = 0;
        byArray[9] = 0;
        byArray[10] = 0;
        return byArray;
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        int[] nArray = new int[SIZE_TIMESTAMPTZ];
        int n = 0;
        while (n < SIZE_TIMESTAMPTZ) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        Calendar calendar = Calendar.getInstance();
        int n2 = TIMESTAMPTZ.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            if (TIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                TIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = TIMEZONETAB.getOffset(calendar, n3);
            calendar.add(10, n4 / HOUR_MILLISECOND);
            calendar.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new DATE(new Date(l));
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        int[] nArray = new int[SIZE_TIMESTAMPTZ];
        int n = 0;
        while (n < SIZE_TIMESTAMPTZ) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        int n2 = TIMESTAMPTZ.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            if (TIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                TIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = TIMEZONETAB.getOffset(calendar, n3);
            calendar.add(10, n4 / HOUR_MILLISECOND);
            calendar.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new Date(l);
    }

    public Object toJdbc() throws SQLException {
        return null;
    }

    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        String string;
        Timestamp timestamp = TIMESTAMPTZ.toTimestamp(connection, byArray);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = 0;
        n7 = (byArray[7] & 0xFF) << 24;
        n7 |= (byArray[8] & 0xFF) << 16;
        n7 |= (byArray[9] & 0xFF) << 8;
        n7 |= byArray[10] & 0xFF & 0xFF;
        if ((byArray[11] & REGIONIDBIT) != 0) {
            int n8 = TIMESTAMPTZ.getHighOrderbits(byArray[11]);
            string = new String(ZONEIDMAP.getRegion(n8 += TIMESTAMPTZ.getLowOrderbits(byArray[12])));
        } else {
            int n9 = byArray[11] - OFFSET_HOUR;
            int n10 = byArray[12] - OFFSET_MINUTE;
            string = new String(String.valueOf(n9) + ":" + n10);
        }
        return String.valueOf(n) + "-" + n2 + "-" + n3 + " " + n4 + "." + n5 + "." + n6 + "." + n7 + " " + string;
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        int[] nArray = new int[SIZE_TIMESTAMPTZ];
        int n = 0;
        while (n < SIZE_TIMESTAMPTZ) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        Calendar calendar = Calendar.getInstance();
        int n2 = TIMESTAMPTZ.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            if (TIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                TIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = TIMEZONETAB.getOffset(calendar, n3);
            calendar.add(10, n4 / HOUR_MILLISECOND);
            calendar.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new Time(l);
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        int[] nArray = new int[SIZE_TIMESTAMPTZ];
        int n = 0;
        while (n < SIZE_TIMESTAMPTZ) {
            nArray[n] = byArray[n] & 0xFF;
            ++n;
        }
        Calendar calendar = Calendar.getInstance();
        int n2 = TIMESTAMPTZ.getJavaYear(nArray[0], nArray[1]);
        calendar.set(1, n2);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, nArray[4] - 1);
        calendar.set(12, nArray[5] - 1);
        calendar.set(13, nArray[6] - 1);
        calendar.set(14, 0);
        if ((nArray[11] & REGIONIDBIT) != 0) {
            int n3 = TIMESTAMPTZ.getHighOrderbits(nArray[11]);
            if (TIMEZONETAB.checkID(n3 += TIMESTAMPTZ.getLowOrderbits(nArray[12]))) {
                TIMEZONETAB.updateTable(connection, n3);
            }
            int n4 = TIMEZONETAB.getOffset(calendar, n3);
            calendar.add(10, n4 / HOUR_MILLISECOND);
            calendar.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
        } else {
            calendar.add(10, nArray[11] - OFFSET_HOUR);
            calendar.add(12, nArray[12] - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        int n5 = nArray[7] << 24;
        n5 |= nArray[8] << 16;
        n5 |= nArray[9] << 8;
        timestamp.setNanos(n5 |= nArray[10] & 0xFF);
        return timestamp;
    }
}

